﻿#include <iostream>
#include <string>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <unordered_map>
#include <random>
#include <chrono>

using namespace std;
using ll = long long;
using pii = pair<int, int>;
using ld = long double;
ll INF = 1e18;
ll NINF = -1e18;

struct r {
	int x, y;
	r(int x1, int y1) {
		x = x1;
		y = y1;
	}

	r operator -(r other) const {
		return { x - other.x, y - other.y };
	}
	
	ld operator %(r other) const {
		return x * other.y - other.x * y;
	}
};

using prr = pair<r, r>;

bool intersect(r a, r b, r c, r d) {
	r temp1 = b - a;
	r temp2 = c - a;
	r temp3 = d - a;
	if ((temp1 % temp2) * (temp1 % temp3) <= 0) {
		temp1 = d - c;
		temp2 = a - c;
		temp3 = b - c;
		if ((temp1 % temp2) * (temp1 % temp3) <= 0) {
			return true;
		}
	}
	return false;
}

vector<vector<int>> g;

int main() {
	int t;
	cin >> t;
	while (t--) {
		g.clear();
		int n;
		cin >> n;
		vector<prr> lines;
		for (int i = 0; i < n; ++i) {
			g.push_back({});
			int x1, y1, x2, y2;
			cin >> x1 >> y1 >> x2 >> y2;
			r temp1(x1, y1);
			r temp2(x2, y2);
			for (int a = 0; a < lines.size(); ++a) {
				if (intersect(temp1, temp2, lines[a].first, lines[a].second) && i != a) {
					g[i].push_back(a);
					g[a].push_back(i);
				}
			}
			lines.emplace_back(temp1, temp2);
		}
		for (int h = 0; h < n; ++h) {
			sort(g[h].begin(), g[h].end());
		}
		ll ans = 0;
		for (int q = 0; q < n; ++q) {
			vector<int> cnt(n, 0);
			for (int u : g[q]) {
				cnt[u]++;
			}
			for (int u : g[q]) {
				for (int v : g[u]) {
					if (cnt[v]) {
						ans++;
					}
				}
			}
		}
		cout << ans / 6 + 1 << endl;
	}
}